<?php

    /*
    Nom du script : php_mysql_liste_complete_villes.php
    Auteur : Christian VIGOUROUX
    Date de création : 14/07/2024
    Date de dernière modification : 14/07/2024
    Objet : Liste des enregistrements de la table MySQL villes de la BDD MySQL
    */

    //http://stackoverflow.com/questions/18382740/cors-not-working-php
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }

    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
            header("Access-Control-Allow-Headers:        {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
        
		exit(0);
    
	} 
	
	// Gestion des accents
	header( 'content-type: text/html; charset=utf-8' );

    // Réponse JSON attendue de la part du script
    header("Content-Type: application/json");

    // Paramètres d'accès aux données (SGBD MySQL)
	$serveur_mysql = "serveur_mysql";
	$utilisateur_mysql = "utilisateur_mysql";
	$mot_de_passe_mysql = "mot_de_passe_mysql";
	$bdd_mysql = "bdd_mysql";

	// Test de connexion à Base De Donnés MySQL
	$bdd = new PDO("mysql:host=$serveur_mysql;dbname=$bdd_mysql", $utilisateur_mysql, $mot_de_passe_mysql);
	if(!$bdd)
	{
		// Message d'erreur envoyé au client
		echo("Erreur de connexion à la Base De Données MySQL");
	}
	else
	{
      
		// Définition de la requête SQL à soumettre
		// à la Base De Données MySQL
		$requete_sql = "SELECT id_ville, nom_ville
						FROM villes";
		// print "<br />Requête SQL : " . $requete_sql;

		// Soumission de la requête SQL au moteur SQL de MySQL
		$resultat_sql = $bdd->prepare($requete_sql);
		$resultat_sql->execute();

		// Balayage des enregistrements
		$nombre_enregistrements = 0;
		while($enregistrement = $resultat_sql->fetch(PDO::FETCH_ASSOC))
		{
			// Affichage de contrôle
			// echo $enregistrement["id_ville"] . ", " , $enregistrement["nom_ville"] . "<br />";

			// Placement des champs (id_ville, nom_ville)
			// de l'enregistrement en cours
			// dans le tableau $lignes (qui contiendra au final
			// l'intégralité des données)
			$lignes[] = $enregistrement;
			$nombre_enregistrements = $nombre_enregistrements + 1;
		}

		// print("Nombre d'enregistrements : " . $nombre_enregistrements);
		
		// Encodage en format JSON du tableau $lignes et envoi du résultat au client
		if ($nombre_enregistrements != 0)
		{
			
			// Encodage en format JSON du tableau $lignes
			$donneesJSON = json_encode($lignes);
	
			// Envoi du résultat au client
			echo $donneesJSON;
		}

	}
	
	// Fermeture de la connexion MySQL
	$bdd = null;

?>